/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.net.URI;
import java.net.URL;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scalaj.http.HttpConstants$;
import scalaj.http.HttpRequest;
import scalaj.http.Token;

public final class OAuth$ {
    public static final OAuth$ MODULE$;
    private final String MAC;

    static {
        new OAuth$();
    }

    public String MAC() {
        return this.MAC;
    }

    public HttpRequest sign(HttpRequest req, Token consumer, Option<Token> token2, Option<String> verifier2) {
        Seq baseParams = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>("oauth_timestamp", ((Object)BoxesRunTime.boxToLong(System.currentTimeMillis() / 1000L)).toString()), new Tuple2<String, String>("oauth_nonce", ((Object)BoxesRunTime.boxToLong(System.currentTimeMillis())).toString())}));
        Tuple2<Seq<Tuple2<String, String>>, String> tuple2 = this.getSig(baseParams, req, consumer, token2, verifier2);
        if (tuple2 != null) {
            Tuple2<Seq<Tuple2<String, String>>, String> tuple22;
            Seq<Tuple2<String, String>> oauthParams = tuple2._1();
            String signature2 = tuple2._2();
            Tuple2<Seq<Tuple2<String, String>>, String> tuple23 = tuple22 = new Tuple2<Seq<Tuple2<String, String>>, String>(oauthParams, signature2);
            Seq<Tuple2<String, String>> oauthParams2 = tuple23._1();
            String signature3 = tuple23._2();
            oauthParams2 = oauthParams2.$plus$colon(new Tuple2<String, String>("oauth_signature", signature3), Seq$.MODULE$.canBuildFrom());
            return req.header("Authorization", new StringBuilder().append((Object)"OAuth ").append((Object)((TraversableOnce)oauthParams2.map(new Serializable(){

                public final String apply(Tuple2<String, String> p) {
                    return new StringBuilder().append((Object)p._1()).append((Object)"=\"").append((Object)OAuth$.MODULE$.percentEncode(p._2())).append((Object)"\"").toString();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Seq<Tuple2<String, String>>, String> getSig(Seq<Tuple2<String, String>> baseParams, HttpRequest req, Token consumer, Option<Token> token2, Option<String> verifier2) {
        Tuple2<String, String> tuple2 = new Tuple2<String, String>("oauth_version", "1.0");
        Tuple2<String, String> tuple22 = new Tuple2<String, String>("oauth_consumer_key", consumer.key());
        Tuple2<String, String> tuple23 = new Tuple2<String, String>("oauth_signature_method", "HMAC-SHA1");
        ObjectRef oauthParams = ObjectRef.create(((SeqLike)((SeqLike)baseParams.$plus$colon(tuple23, Seq$.MODULE$.canBuildFrom())).$plus$colon(tuple22, Seq$.MODULE$.canBuildFrom())).$plus$colon(tuple2, Seq$.MODULE$.canBuildFrom()));
        token2.foreach(new Serializable(oauthParams){
            private final ObjectRef oauthParams$1;

            public final void apply(Token t) {
                this.oauthParams$1.elem = ((Seq)this.oauthParams$1.elem).$plus$colon(new Tuple2<String, String>("oauth_token", t.key()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.oauthParams$1 = oauthParams$1;
            }
        });
        verifier2.foreach(new Serializable(oauthParams){
            private final ObjectRef oauthParams$1;

            public final void apply(String v) {
                this.oauthParams$1.elem = ((Seq)this.oauthParams$1.elem).$plus$colon(new Tuple2<String, String>("oauth_verifier", v), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.oauthParams$1 = oauthParams$1;
            }
        });
        String baseString = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{req.method().toUpperCase(), this.normalizeUrl(new URL(req.url())), this.normalizeParams(req.params().$plus$plus((Seq)oauthParams.elem, Seq$.MODULE$.canBuildFrom()))}))).map(new Serializable(){

            public final String apply(String s2) {
                return OAuth$.MODULE$.percentEncode(s2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("&");
        String keyString = new StringBuilder().append((Object)this.percentEncode(consumer.secret())).append((Object)"&").append((Object)token2.map(new Serializable(){

            public final String apply(Token t) {
                return OAuth$.MODULE$.percentEncode(t.secret());
            }
        }).getOrElse(new Serializable(){

            public final String apply() {
                return "";
            }
        })).toString();
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(HttpConstants$.MODULE$.utf8()), this.MAC());
        Mac mac = Mac.getInstance(this.MAC());
        mac.init(key);
        byte[] text2 = baseString.getBytes(HttpConstants$.MODULE$.utf8());
        return new Tuple2<Seq<Tuple2<String, String>>, String>((Seq)oauthParams.elem, HttpConstants$.MODULE$.base64(mac.doFinal(text2)));
    }

    private String normalizeParams(Seq<Tuple2<String, String>> params2) {
        return ((TraversableOnce)this.percentEncode(params2).sortWith((Function2<String, String, Object>)((Object)new Serializable(){

            public final boolean apply(String x$5, String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).$less(x$6);
            }
        }))).mkString("&");
    }

    private String normalizeUrl(URL url) {
        String path2;
        int index2;
        boolean dropPort;
        URI uri = new URI(url.toString());
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index2 = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index2);
        }
        if ((path2 = uri.getRawPath()) == null || path2.length() <= 0) {
            path2 = "/";
        }
        return new StringBuilder().append((Object)scheme).append((Object)"://").append((Object)authority).append((Object)path2).toString();
    }

    public Seq<String> percentEncode(Seq<Tuple2<String, String>> params2) {
        return params2.map(new Serializable(){

            public final String apply(Tuple2<String, String> p) {
                return new StringBuilder().append((Object)OAuth$.MODULE$.percentEncode(p._1())).append((Object)"=").append((Object)OAuth$.MODULE$.percentEncode(p._2())).toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String percentEncode(String s2) {
        return s2 == null ? "" : HttpConstants$.MODULE$.urlEncode(s2, HttpConstants$.MODULE$.utf8()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private OAuth$() {
        MODULE$ = this;
        this.MAC = "HmacSHA1";
    }
}

